/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.screens;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import journeymap.client.Constants;
import journeymap.client.event.handlers.KeybindingHandler;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.screens.JmUI;
import journeymap.client.ui.component.widgets.LogoWidget;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_11278;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import org.apache.logging.log4j.Logger;

public abstract class JmUILegacy
extends class_437 {
    protected final String title;
    protected final int headerHeight = 36;
    protected final int footerHeight = 30;
    protected final Logger logger = Journeymap.getLogger();
    protected double scaleFactor = 1.0;
    protected static Stack<class_437> returnDisplayStack = JmUI.returnDisplayStack;
    protected boolean renderBottomBar = false;
    private final class_11278 guiProjectionMatrixBuffer = new class_11278("jmui", 1000.0f, 11000.0f, true);
    protected LogoWidget logoWidget;

    public JmUILegacy(String title) {
        this(title, null);
    }

    public JmUILegacy(String title, class_437 returnDisplay) {
        super((class_2561)Constants.getStringTextComponent(title));
        this.title = title;
        returnDisplayStack.push(returnDisplay);
    }

    public class_310 getMinecraft() {
        return class_310.method_1551();
    }

    public void method_25423(int width, int height) {
        super.method_25423(width, height);
        this.scaleFactor = JmUI.calculateScaleFactor();
    }

    public boolean method_25421() {
        return true;
    }

    public class_327 getFontRenderer() {
        return this.field_22793;
    }

    protected boolean isMouseOverButton(double mouseX, double mouseY) {
        for (int k = 0; k < this.getRenderables().size(); ++k) {
            Button button;
            class_4185 guibutton = (class_4185)this.getRenderables().get(k);
            if (!(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    protected void drawLogo(class_332 graphics, class_4587 poseStack) {
        if (this.logoWidget == null) {
            this.logoWidget = new LogoWidget(JmUI::calculateScaleFactor);
        }
        this.logoWidget.method_48579(graphics, 0, 0, 0.0f);
    }

    protected void renderBottomBar(class_332 graphics, class_4587 poseStack) {
        if (this.renderBottomBar) {
            DrawUtil.drawRectangle(graphics, 0.0, this.field_22790 - 30, this.field_22789, this.field_22790, 0, 0.6f);
        }
    }

    protected void drawTitle(class_332 graphics, class_4587 poseStack) {
        DrawUtil.drawRectangle(graphics, 0.0, 0.0, this.field_22789, 36.0, 0, 0.9f);
        DrawUtil.drawLabel(graphics, (class_2561)class_2561.method_43470((String)this.title), this.field_22789 / 2, 18.0, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, 0, 0.0f, Color.CYAN.getRGB(), 1.0f, 1.0, true, 0.0);
        String apiVersion = "API v2.0.0-SNAPSHOT";
        DrawUtil.drawLabel(graphics, (class_2561)class_2561.method_43470((String)apiVersion), this.field_22789 - 10, 18.0, DrawUtil.HAlign.Left, DrawUtil.VAlign.Middle, 0, 0.0f, 0xCCCCCC, 1.0f, 0.5, true, 0.0);
    }

    public void method_25426() {
        this.getRenderables().clear();
    }

    public void method_25420(class_332 graphics, int i, int j, float f) {
        if (class_310.method_1551().field_1687 == null) {
            this.drawGradientRect(graphics, 0, 0, this.field_22789, this.field_22790, -1072689136, -804253680, 0);
        } else {
            super.method_25420(graphics, i, j, f);
        }
    }

    protected abstract void layoutButtons(class_332 var1, class_4587 var2);

    public <T extends class_364 & class_4068> T method_37063(T widget) {
        return (T)super.method_37063(widget);
    }

    public <T extends class_4068> T method_37060(T renderable) {
        return (T)super.method_37060(renderable);
    }

    public void method_25394(class_332 graphics, int x, int y, float partialTicks) {
        try {
            class_4587 pose = new class_4587();
            this.renderBottomBar(graphics, pose);
            this.layoutButtons(graphics, pose);
            this.drawTitle(graphics, pose);
            this.drawLogo(graphics, pose);
            List<class_5481> tooltip = null;
            for (int k = 0; k < this.getRenderables().size(); ++k) {
                Button button;
                class_4068 guibutton = this.getRenderables().get(k);
                guibutton.method_25394(graphics, x, y, 0.0f);
                if (tooltip != null || !(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(x, y)) continue;
                tooltip = button.getWrappedTooltip();
            }
            if (tooltip != null && !tooltip.isEmpty()) {
                this.renderWrappedToolTip(graphics, pose, tooltip, x, y, this.getFontRenderer());
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error in UI: " + LogFormatter.toString(t));
            this.closeAndReturn();
        }
    }

    public void drawGradientRect(class_332 graphics, int pX1, int pY1, int pX2, int pY2, int pColorFrom, int pColorTo, int pBlitOffset) {
        graphics.method_25296(pX1, pY1, pX2, pY2, pColorFrom, pColorTo);
    }

    protected void closeAndReturn() {
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open(returnDisplayStack.pop());
        }
        this.guiProjectionMatrixBuffer.close();
    }

    public void closeWithKeyBind() {
        this.closeAndReturn();
    }

    public void setRenderBottomBar(boolean renderBottomBar) {
        this.renderBottomBar = renderBottomBar;
    }

    public boolean method_25404(class_11908 event) {
        switch (event.comp_4795()) {
            case 256: {
                this.closeAndReturn();
                return true;
            }
        }
        if (super.method_25404(event)) {
            return true;
        }
        return KeybindingHandler.getInstance().consume(this, (class_11907)event);
    }

    public void renderTooltip(class_332 graphics, class_4587 pose, String[] tooltip, int mouseX, int mouseY) {
        List tooltips = Arrays.stream(tooltip).map(e -> class_5481.method_30747((String)e, (class_2583)class_2583.field_24360)).collect(Collectors.toList());
        this.renderWrappedToolTip(graphics, pose, tooltips, mouseX, mouseY, this.getFontRenderer());
    }

    public class_437 getReturnDisplay() {
        return returnDisplayStack.peek();
    }

    public void renderWrappedToolTip(class_332 graphics, class_4587 pose, List tooltip, int mouseX, int mouseY, class_327 fontRenderer) {
        if (!tooltip.isEmpty() && tooltip.get(0) instanceof class_5481 && class_310.method_1551().field_1755 == this) {
            RenderWrapper.disableDepthTest();
            int maxLineWidth = 0;
            for (class_5481 line : tooltip) {
                int lineWidth = fontRenderer.method_30880(line);
                if (fontRenderer.method_1726()) {
                    lineWidth = (int)Math.ceil((double)lineWidth * 1.25);
                }
                if (lineWidth <= maxLineWidth) continue;
                maxLineWidth = lineWidth;
            }
            int drawX = mouseX + 12;
            int drawY = mouseY - 12;
            int boxHeight = 8;
            if (tooltip.size() > 1) {
                boxHeight += 2 + (tooltip.size() - 1) * 10;
            }
            if (drawX + maxLineWidth > this.field_22789) {
                drawX -= 28 + maxLineWidth;
            }
            if (drawY + boxHeight + 6 > this.field_22790) {
                drawY = this.field_22790 - boxHeight - 6;
            }
            if (drawY - 4 < 0) {
                drawY = 4;
            }
            int j1 = -267386864;
            this.drawGradientRect(graphics, drawX - 3, drawY - 4, drawX + maxLineWidth + 3, drawY - 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY + boxHeight + 3, drawX + maxLineWidth + 3, drawY + boxHeight + 4, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY + boxHeight + 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 4, drawY - 3, drawX - 3, drawY + boxHeight + 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX + maxLineWidth + 3, drawY - 3, drawX + maxLineWidth + 4, drawY + boxHeight + 3, j1, j1, 300);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            this.drawGradientRect(graphics, drawX - 3, drawY - 3 + 1, drawX - 3 + 1, drawY + boxHeight + 3 - 1, k1, l1, 300);
            this.drawGradientRect(graphics, drawX + maxLineWidth + 2, drawY - 3 + 1, drawX + maxLineWidth + 3, drawY + boxHeight + 3 - 1, k1, l1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY - 3 + 1, k1, k1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY + boxHeight + 2, drawX + maxLineWidth + 3, drawY + boxHeight + 3, l1, l1, 300);
            for (int i2 = 0; i2 < tooltip.size(); ++i2) {
                class_5481 line = (class_5481)tooltip.get(i2);
                if (fontRenderer.method_1726()) {
                    int lineWidth = (int)Math.ceil((double)fontRenderer.method_30880(line) * 1.1);
                    graphics.method_51430(this.field_22793, line, drawX + maxLineWidth - lineWidth, drawY, -1, true);
                } else {
                    graphics.method_51430(this.field_22793, line, drawX, drawY, -1, true);
                }
                if (i2 == 0) {
                    drawY += 2;
                }
                drawY += 10;
            }
            RenderWrapper.enableDepthTest();
        }
    }

    public List<class_4068> getRenderables() {
        return this.field_33816;
    }
}

